unit frmuTelDetails;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, Mask, DBCtrls, DB, System.ComponentModel;

type
  TfrmTelDetails = class(TForm)
    btnOK: TBitBtn;
    btnCancel: TBitBtn;
    Label1: TLabel;
    DataSource1: TDataSource;
    edtFirstName: TDBEdit;
    Label2: TLabel;
    edtLastName: TDBEdit;
    Label3: TLabel;
    edtAddress: TDBEdit;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent; New: boolean); reintroduce;
    destructor Destroy; override;
  end;

implementation

uses dmuTel;

{$R *.dfm}

constructor TfrmTelDetails.Create(AOwner: TComponent; New: boolean);
begin
  inherited Create(AOwner);
  if New then
    dmTel.cdsFriends.Append
  else
    dmTel.cdsFriends.Edit;
end;

destructor TfrmTelDetails.Destroy;
begin
  dmTel.cdsFriends.Cancel;
  inherited;
end;

procedure TfrmTelDetails.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  if ModalResult = mrOk then
  begin
    try
      if dmTel.cdsFriends.State in [dsEdit, dsInsert] then
      begin
        if dmTel.cdsFriends.FieldByName('FRIENDID').IsNull then
          dmTel.cdsFriends.FieldByName('FRIENDID').AsInteger := dmTel.NextFriendId;
        dmTel.cdsFriends.Post;
      end;
    except
      Action := caNone;
      raise;
    end;
  end;
end;

procedure TfrmTelDetails.FormShow(Sender: TObject);
begin
  edtFirstName.SetFocus;
end;

end.
